# Yowao Navigation Pro (要哇棱镜导航主题)

> **Slogan:** 极速 · 安全 · 高颜值 —— 专为国人打造的极客导航主题。

**Yowao Navigation Pro** 是一款基于 WordPress 开发的高性能导航主题。它采用了独特的“棱镜”视觉风格，集成了银行级 CSRF 安全防护，并针对国内网络环境进行了深度优化（去谷歌化、Cravatar 加速）。

🎉 **完全开源，没有任何限制！**
你可以免费使用、修改、分发，甚至移除底部的版权信息，将其作为你自己的作品发布。

## ✨ 核心特性

* **🛡️ 极致安全**：全站接口重构，引入 Nonce 动态加密验证，彻底杜绝恶意注册和接口攻击 (403 防护)。
* **🚀 国内秒开**：
    * **0 延迟**：移除所有 Google Fonts/Icons 外部依赖。
    * **极速头像**：内置 Cravatar 国内镜像源，解决 Gravatar 头像裂图问题。
    * **本地化资源**：核心 JS/CSS 库完全本地化，拒绝 CDN 连通性风险。
* **🎨 棱镜视觉**：iOS 锁屏风格超大时钟、3D 玻璃拟态卡片、自适应响应式布局。
* **⚡️ 丝滑体验**：注册成功自动登录、智能错误弹窗、后台可视化管理排序。

## 📥 环境准备与安装

### 1. 下载 WordPress (中文版)
如果您还没有搭建 WordPress，请前往官网下载最新中文版：
👉 **[点击下载 WordPress 中文版](https://cn.wordpress.org/download/)**

### 2. 安装主题 (二选一)

#### 方法 A：WordPress 后台安装 (推荐)
1.  下载本仓库的 `.zip` 主题压缩包。
2.  进入 WordPress 后台 -> `外观` -> `主题` -> `添加` -> `上传主题`。
3.  选择上传的文件，安装并点击“启用”。

#### 方法 B：直接解压上传
1.  解压下载的压缩包。
2.  使用 FTP 工具或宝塔面板的文件管理器。
3.  将解压得到的 `yowao-theme` 文件夹上传到服务器的 `/wp-content/themes/` 目录下。
4.  进入 WordPress 后台 -> `外观` -> `主题`，找到该主题并启用。

> **🔴 重要提示 (必做)：**
> 启用主题后，请务必去后台 **`设置` -> `固定链接`** 页面，**不需要修改任何选项，直接点击一次“保存更改”按钮**。
> *(这一步是为了刷新伪静态规则，防止新增的“网址”和“书签”出现 404 打不开的情况)*

## 📧 邮件功能配置 (重要)

本主题支持**“邮箱验证码注册”**和**“找回密码”**功能。为了确保邮件能发送成功，您必须配置 SMTP。

**推荐方案：使用 `WP Mail SMTP` 插件**

1.  在 WordPress 后台 -> `插件` -> `安装插件`，搜索 **WP Mail SMTP** 并安装启用。
2.  进入插件设置向导，选择您的邮件服务商（如 QQ邮箱、网易邮箱、Gmail 或 其他 SMTP）。
3.  **配置关键信息**（以 QQ 邮箱为例）：
    * **SMTP 主机**: `smtp.qq.com`
    * **加密方式**: `SSL` / 端口 `465`
    * **用户名**: 您的完整 QQ 邮箱地址
    * **密码**: **注意！这里不能填 QQ 登录密码，必须去 QQ 邮箱网页版设置里开启 SMTP 并获取“授权码”。**
4.  配置完成后，使用插件自带的“发送测试邮件”功能，确保能收到邮件。

*配置好 SMTP 后，主题的注册验证码功能即可正常使用。*

## 🖼️ 如何自定义背景壁纸

为了避免版权争议，本主题包默认 **不包含** 本地壁纸文件（默认会自动加载一张 Unsplash 在线无版权图片）。

**如果您想使用自己的壁纸，请按以下步骤操作：**

1.  准备您喜欢的壁纸图片（推荐尺寸 1920x1080 或更高）。
2.  将图片文件（支持 `.jpg`, `.png`, `.webp`）上传到主题文件夹下的 **`assets/img/bg/`** 目录中。
    * **路径示例**：`/wp-content/themes/yowao-theme/assets/img/bg/`
3.  **大功告成！** 刷新首页，主题会自动检测该文件夹下的所有图片，并每次刷新随机展示一张。

## ⚙️ 使用说明

* **添加网址**：在后台左侧菜单 `网址导航` -> `添加网址`。列表前两个网址会自动显示为“宽版卡片”，后续显示为“标准图标”。
* **拖拽排序**：在后台列表页，支持按“类型”或“点赞数”进行排序查看。
* **主题设置**：在 `主题设置` 菜单中，可配置 SEO、备案号、Logo 及开启/关闭邮箱验证注册。
* **私有书签**：用户登录后，前台会出现“我的收藏”区域，可添加仅自己可见的私有链接。

## ⚠️ 注意事项

1.  **环境要求**：建议使用 PHP 7.4 或 PHP 8.0+ 以获得最佳性能。
2.  **文件权限**：请确保 `/wp-content/uploads/` 目录具有写入权限（用于缓存 Favicon 图标和天气数据）。

## 📜 开源协议 & 声明

本项目代码基于 **GPL v3** 协议开源（为了兼容 WordPress 生态）。

但在作者的主观意愿上，**我不做任何权利保留**：
* ✅ 允许个人或商业免费使用。
* ✅ 允许二次开发并再次发布。
* ✅ **允许移除主题底部和代码中的作者署名**。

*希望这款主题能帮到更多需要搭建导航站的朋友！*